% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph_search.R
\name{ma_graph_search}
\alias{ma_graph_search}
\title{Graph search API}
\usage{
ma_graph_search(query, mode = "json", key = NULL, ...)
}
\arguments{
\item{query}{(character) query terms}

\item{mode}{(character) json (default) or lambda}

\item{key}{(character) microsoft academic API key, see the \code{Authentication}
section in \link{microdemic-package}}

\item{...}{curl options passed on to \link[crul:HttpClient]{crul::HttpClient}}
}
\description{
Graph search API
}
\examples{
\dontrun{
x <- '{
"path": "/paper/AuthorIDs/author",
 "paper": {
   "type": "Paper",
   "NormalizedTitle": "graph engine",
   "select": [ "OriginalTitle" ]
 },
 "author": {
   "return": { "type": "Author", "Name": "bin shao" }
 }
}'

res <- ma_graph_search(query = x)
res$Results
do.call(rbind, res$Results)
}
}
\references{
\url{https://westus.dev.cognitive.microsoft.com/docs/services/56332331778daf02acc0a50b/operations/57e3569ddbe2d91158fa270e}
graph search method: \url{https://docs.microsoft.com/en-us/azure/cognitive-services/academic-knowledge/graphsearchmethod}
json search: \url{https://docs.microsoft.com/en-us/azure/cognitive-services/academic-knowledge/jsonsearchsyntax}
lambda search: \url{https://docs.microsoft.com/en-us/azure/cognitive-services/academic-knowledge/lambdasearchsyntax}
}
