% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/st_heatmap.R
\name{st_heatmap}
\alias{st_heatmap}
\title{Plot a heatmap of the stability results}
\usage{
st_heatmap(
  data,
  order = "none",
  label = FALSE,
  low = "red2",
  mid = "yellow",
  high = "forestgreen",
  midpoint = 0.5
)
}
\arguments{
\item{data}{input data frame resulting from \code{\link[=st_previz]{st_previz()}}.}

\item{order}{character: none, mean or median; if the heatmap should be sorted by any of those statistics of the stability values by individuals.}

\item{label}{logical; FALSE to avoid printing the value or TRUE to print it.}

\item{low}{color for the lowest value.}

\item{mid}{color for the middle value.}

\item{high}{color for the highest values.}

\item{midpoint}{value to situate the middle.}
}
\value{
A heatmap of the stability values in the form of a "ggplot" object
}
\description{
Plot a heatmap of the stability results
}
\examples{
t1_t2 <- paired_times(data = clr[,1:25], first = "_1",
                      second = "_25", common = "_0_")
t2_t3 <- paired_times(data = clr[,1:25], first = "_25",
                      second = "_26", common = "_0_")
klist_t1_t2 <- iterative_clustering(data = t1_t2, parallel = FALSE)
klist_t2_t3 <- iterative_clustering(data = t2_t3, parallel = FALSE)
result_t1_t2 <- stabilitas(klist_t1_t2, common = "_0_")
result_t2_t3 <- stabilitas(klist_t2_t3, common = "_0_")
results <- st_previz(results = list(result_t1_t2, result_t2_t3),
                     times = c("t1_t2", "t2_t3"))
st_heatmap(data = results, order = "mean", label = TRUE)
}
