% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BEKK.R
\name{BEKK}
\alias{BEKK}
\title{Provide the MGARCH-BEKK estimation procedure.}
\usage{
BEKK(eps, order = c(1, 1), params = NULL, fixed = NULL, method = "BFGS",
  verbose = F)
}
\arguments{
\item{eps}{Data frame holding time series.}

\item{order}{BEKK(p, q) order}

\item{params}{Initial parameters for the \code{optim} function.}

\item{fixed}{Vector of parameters to be fixed.}

\item{method}{The method that will be used by the \code{optim} function.}

\item{verbose}{Indicates if we need verbose output during the estimation.}
}
\value{
Estimation results packaged as \code{BEKK} class instance.
}
\description{
Provide the MGARCH-BEKK estimation procedure.
}
\examples{
## Simulate series:
simulated <- simulateBEKK(2, 1000, c(1,1))

## Prepare the matrix:
simulated <- do.call(cbind, simulated$eps)

## Estimate with default arguments:
estimated <- BEKK(simulated)

\dontrun{
## Show diagnostics:
diagnoseBEKK(estimated)
}

}

