% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reg_d1.R
\name{d1}
\alias{d1}
\title{Modified Index of Agreement (d1).}
\usage{
d1(data = NULL, obs, pred, tidy = FALSE, na.rm = TRUE)
}
\arguments{
\item{data}{(Optional) argument to call an existing data frame containing the data.}

\item{obs}{Vector with observed values (numeric).}

\item{pred}{Vector with predicted values (numeric).}

\item{tidy}{Logical operator (TRUE/FALSE) to decide the type of return. TRUE
returns a data.frame, FALSE returns a list; Default : FALSE.}

\item{na.rm}{Logic argument to remove rows with missing values
(NA). Default is na.rm = TRUE.}
}
\value{
an object of class \code{numeric} within a \code{list} (if tidy = FALSE) or within a
\verb{data frame} (if tidy = TRUE).
}
\description{
It estimates the modified index of agreement (d1) using absolute
differences following Willmott et al. (1985).
}
\details{
Similar to d, the d1 index it is a normalized, dimensionless metric that tests general agreement.
The difference with d, is that d1 uses absolute residuals instead of squared residuals. It is bounded between 0 and 1.
The disadvantage is that d is an asymmetric index, that is, dependent to the orientation of
predicted and observed values.
For the formula and more details, see \href{https://adriancorrendo.github.io/metrica/articles/available_metrics_regression.html}{online-documentation}
}
\examples{
\donttest{
set.seed(1)
X <- rnorm(n = 100, mean = 0, sd = 10)
Y <- rnorm(n = 100, mean = 0, sd = 9)
d1(obs = X, pred = Y)
}
}
\references{
Willmott et al. (1985).
Statistics for the evaluation and comparison of models.
\emph{J. Geophys. Res. 90, 8995.} \doi{10.1029/jc090ic05p08995}
}
