% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KGE.R
\name{KGE}
\alias{KGE}
\title{Kling-Gupta Model Efficiency (KGE).}
\usage{
KGE(data = NULL, obs, pred, na.rm = TRUE)
}
\arguments{
\item{data}{(Optional) argument to call an existing data frame containing the data.}

\item{obs}{Vector with observed values (numeric).}

\item{pred}{Vector with predicted values (numeric).}

\item{na.rm}{Logic argument to remove rows with missing values
(NA). Default is na.rm = TRUE.}
}
\value{
an object of class \code{numeric}.
}
\description{
It estimates the KGE for a predicted-observed dataset.
}
\details{
The KGE is a normalized, dimensionless, model efficiency that measures general agreement.
It presents accuracy, precision, and consistency components. It is symmetric
(invariant to predicted observed orientation). It is positively bounded up to 1.
The closer to 1 the better.
For the formula and more details, see \href{https://adriancorrendo.github.io/metrica/articles/available_metrics.html}{online-documentation}
}
\examples{
\donttest{
set.seed(1)
X <- rnorm(n = 100, mean = 0, sd = 10)
Y <- rnorm(n = 100, mean = 0, sd = 9)
KGE(obs = X, pred = Y)
}
}
\references{
Kling et al. (2012).
Runoff conditions in the upper Danube basin under an ensemble of climate change scenarios.
\emph{Journal of Hydrology 424-425, 264-277.} \doi{doi:10.1016/j.jhydrol.2012.01.011}
}
