% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modifiedMPD.R
\name{modifiedMPD}
\alias{modifiedMPD}
\title{Calculate different versions of abundance-weighted MPD}
\usage{
modifiedMPD(samp, dis, abundance.weighted = FALSE)
}
\arguments{
\item{samp}{A picante-style community data matrix with sites as rows, and
species as columns}

\item{dis}{Phylogenetic distance matrix}

\item{abundance.weighted}{One of either "FALSE", "interspecific",
"intraspecific", or "complete"}
}
\value{
A vector of MPD values, calculated according to the abundance-weighted method
specified.
}
\description{
Given a picante-style community data matrix (sites are rows, species are columns), 
a phylogenetic distance matrix, and a desired method of abundance-weighting, will
calculate MPD.
}
\details{
See accompanying publication for details. Non-abundance-weighted and
interspecific and intraspecific methods are equivalent to those previously described by
Clarke & Warwick.
}
\examples{
#simulate tree with birth-death process
tree <- geiger::sim.bdtree(b=0.1, d=0, stop="taxa", n=50)

sim.abundances <- round(rlnorm(5000, meanlog=2, sdlog=1)) + 1

cdm <- simulateComm(tree, richness.vector=10:25, abundances=sim.abundances)

dists <- ape::cophenetic.phylo(tree)

results <- modifiedMPD(cdm, dists, abundance.weighted = "interspecific")
}
\references{
Miller, E. T., D. R. Farine, and C. H. Trisos. 2016. Phylogenetic community
structure metrics and null models: a review with new methods and software.
Ecography DOI: 10.1111/ecog.02070
}

