% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeCDM.R
\name{makeCDM}
\alias{makeCDM}
\title{Wrapper for creating a CDM from a spatial simulation result}
\usage{
makeCDM(single.simulation, no.plots, plot.length)
}
\arguments{
\item{single.simulation}{The results of a single spatial simulation, e.g. a call to
randomArena}

\item{no.plots}{The desired number of plots in the final CDM}

\item{plot.length}{The length of one side of each plot}
}
\value{
A list with the regional abundance from the single simulation result, if it
included such a result, or the results of a call to abundanceVector() if not. The list
also includes the CDM based on the parameters (number and size of plots) provided.
}
\description{
Given the results of a single spatial simulation, and a desired number of plots
and the length of one side of each plot, will place the plots down and output
a CDM. Importantly, also carries along the regional abundance vector from the
spatial simulation results if one was included.
}
\details{
Just a simple wrapper function to quickly turn spatial simulations into CDMs
for subsequent analysis.
}
\examples{
tree <- geiger::sim.bdtree(b=0.1, d=0, stop="taxa", n=50)

#prep the data for the simulation
prepped <- prepSimulations(tree, arena.length=300, mean.log.individuals=2, 
length.parameter=5000, sd.parameter=50, max.distance=20, proportion.killed=0.2,
competition.iterations=3)

competition <- competitionArena(prepped)

test <- makeCDM(competition, 15, 30)
}
\references{
Miller, E. T., D. R. Farine, and C. H. Trisos. 2016. Phylogenetic community
structure metrics and null models: a review with new methods and software.
Ecography DOI: 10.1111/ecog.02070
}

