% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evolveTraits.R
\name{evolveTraits}
\alias{evolveTraits}
\title{Evolve two traits up a tree}
\usage{
evolveTraits(tree, sigma = 0.1)
}
\arguments{
\item{tree}{A phylogeny.}

\item{sigma}{The Brownian motion rate parameter.}
}
\value{
A list where the first object is a phylogeny with the desired number of species
and the second object is a matrix of trait values for those species.
}
\description{
Given a phylogeny, will generate associated trait data for two traits following a 
Brownian motion evolution model.
}
\details{
Evolves two traits independently up phylogeny with Brownian motion evolution 
process. Sigma is currently set to 0.1 as default.
}
\examples{
tree <- geiger::sim.bdtree(b=0.1, d=0, stop="taxa", n=50)

results <- evolveTraits(tree)
}
\references{
Miller, E. T., D. R. Farine, and C. H. Trisos. 2016. Phylogenetic community
structure metrics and null models: a review with new methods and software.
Ecography DOI: 10.1111/ecog.02070
}

