% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractdates.R, R/extractgridpoints.R
\name{extractvars}
\alias{extractvars}
\alias{extractdates}
\alias{extractgridindex}
\alias{extractgridpoints}
\title{Extracts meteorological data}
\usage{
extractvars(object, vars, verbose = FALSE)

extractdates(object, dates = NULL, verbose = FALSE)

extractgridindex(grid, index)

extractgridpoints(grid, points, verbose = FALSE)
}
\arguments{
\item{object}{An object of class \code{\link{SpatialPointsMeteorology}},
\code{\link{SpatialGridMeteorology}} or
\code{\link{SpatialPixelsMeteorology}}.}

\item{vars}{A character vector with the set of variables to be extracted.}

\item{verbose}{Boolean flag to print process information.}

\item{dates}{A vector of \code{\link{Date}} with a (subset) of dates to be
extracted. If \code{NULL} all dates will be returned.}

\item{grid}{An object of class \code{\link{SpatialGridMeteorology-class}} or
\code{\link{SpatialPixelsMeteorology-class}} with the meteorological data
for a full grid or a subset of grid cells, respectively. Alternatively, a
string specifying a NetCDF to be read from the disk.}

\item{index}{An integer with a grid index.}

\item{points}{An object of class \code{\link{SpatialPoints}}.}
}
\value{
\itemize{ \item{Function \code{extractdates()}, returns a \code{list}
with the same length as \code{dates}. Each element of the list is a spatial
object (\code{\link{SpatialPointsDataFrame}},
\code{\link{SpatialGridDataFrame}} or \code{\link{SpatialPixelsDataFrame}},
depending on the input) with the meteorological data for all the spatial
elements. If only one date is asked, the function returns directly the
spatial object, without embedding it into a list.} \item{Function
\code{extractvars()}, returns a \code{list} with the same length as
\code{vars}. Each element of the list is a spatial object
(\code{\link{SpatialPointsDataFrame}}, \code{\link{SpatialGridDataFrame}} or
\code{\link{SpatialPixelsDataFrame}}, depending on the input) with the
meteorological data for all the spatial elements. If only one variable is
asked, the function returns directly the spatial object, without embedding
it into a list.} \item{Function \code{extractgridindex()} returns a data
frame.} \item{Function \code{extractgridpoints()} returns an object of class
\code{\link{SpatialPointsMeteorology}}.} }
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

Extracts meteorological data from an object.
}
\details{
Function \code{extractpoints} is deprecated, because its functionality can
be achieved using subsetting of spatial classes
\code{\link{SpatialGridMeteorology}} and
\code{\link{SpatialPixelsMeteorology}}.
}
\section{Functions}{
\itemize{
\item \code{extractvars()}: \ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

\item \code{extractgridindex()}: \ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

\item \code{extractgridpoints()}: \ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

}}
\author{
Miquel De \enc{Cáceres}{Caceres} Ainsa, CREAF
}
