% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metasnf-package.R
\docType{package}
\name{metasnf-package}
\alias{metasnf}
\alias{metasnf-package}
\title{metasnf: Meta Clustering with Similarity Network Fusion}
\description{
Framework to facilitate patient subtyping with similarity network fusion and meta clustering. The similarity network fusion (SNF) algorithm was introduced by Wang et al. (2014) in \doi{10.1038/nmeth.2810}. SNF is a data integration approach that can transform high-dimensional and diverse data types into a single similarity network suitable for clustering with minimal loss of information from each initial data source. The meta clustering approach was introduced by Caruana et al. (2006) in \doi{10.1109/ICDM.2006.103}. Meta clustering involves generating a wide range of cluster solutions by adjusting clustering hyperparameters, then clustering the solutions themselves into a manageable number of qualitatively similar solutions, and finally characterizing representative solutions to find ones that are best for the user's specific context. This package provides a framework to easily transform multi-modal data into a wide range of similarity network fusion-derived cluster solutions as well as to visualize, characterize, and validate those solutions. Core package functionality includes easy customization of distance metrics, clustering algorithms, and SNF hyperparameters to generate diverse clustering solutions; calculation and plotting of associations between features, between patients, and between cluster solutions; and standard cluster validation approaches including resampled measures of cluster stability, standard metrics of cluster quality, and label propagation to evaluate generalizability in unseen data. Associated vignettes guide the user through using the package to identify patient subtypes while adhering to best practices for unsupervised learning.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://branchlab.github.io/metasnf/}
  \item \url{https://github.com/BRANCHlab/metasnf/}
  \item Report bugs at \url{https://github.com/BRANCHlab/metasnf/issues}
}

}
\author{
\strong{Maintainer}: Prashanth S Velayudhan \email{psvelayu@gmail.com}

Authors:
\itemize{
  \item Xiaoqiao Xu
  \item Prajkta Kallurkar
  \item Ana Patricia Balbon
  \item Maria T Secara
  \item Adam Taback
  \item Denise Sabac
  \item Nicholas Chan
  \item Shihao Ma
  \item Bo Wang
  \item Daniel Felsky
  \item Stephanie H Ameis
  \item Brian Cox
  \item Colin Hawco
  \item Lauren Erdman
  \item Anne L Wheeler \email{anne.wheeler@sickkids.ca} [thesis advisor]
}

}
\keyword{internal}
