% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scatter.R
\name{metapanel}
\alias{metapanel}
\title{Panel Function for Metaplot Scatterplot}
\usage{
metapanel(x, y, groups, xref = NULL, yref = NULL, ysmooth = FALSE,
  xsmooth = FALSE, fit = conf, conf = FALSE, loc = 0, iso = FALSE,
  global = FALSE, msg = "metastats", type, ...)
}
\arguments{
\item{x}{x values}

\item{y}{y values}

\item{groups}{optional grouping item}

\item{xref}{reference line from x axis}

\item{yref}{reference line from y axis}

\item{ysmooth}{supply loess smooth of y on x}

\item{xsmooth}{supply loess smmoth of x on y}

\item{fit}{draw a linear fit of y ~ x}

\item{conf}{logical, or width for a confidence region around a linear fit; passed to \code{\link{region}}; \code{TRUE} defaults to 95 percent confidence interval}

\item{loc}{where to print statistics on a panel; suppressed for grouped plots}

\item{iso}{use isometric axes with line of unity}

\item{global}{if TRUE, xsmooth, ysmooth, fit, and conf are applied to all data rather than groupwise}

\item{msg}{a function to print text on a panel: called with x values, y values, and \dots.}

\item{type}{overridden by metapanel}

\item{...}{passed to panel.superpose, panel.xyplot, panel.polygon, region, panel.text}
}
\description{
Panel function for metaplot::scatterplot.data.frame.
}
\seealso{
\code{\link{metastats}}

\code{\link{scatter.data.frame}}

Other panel functions: \code{\link{l.p}},
  \code{\link{my.diag.panel}}, \code{\link{u.p}}

Other scatter: \code{\link{scatter.data.frame}},
  \code{\link{scatter_data_frame}}, \code{\link{scatter}}
}
