% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metaphonebr.R
\name{metaphonebr}
\alias{metaphonebr}
\title{Generates Phonetic Code  (adapted Metaphone-BR) for Names in Portuguese}
\usage{
metaphonebr(fullnames, verbose = FALSE)
}
\arguments{
\item{fullnames}{A character vector for names to be processed.}

\item{verbose}{Logical, if \code{TRUE}, print progress messages at each step.
Default  \code{FALSE}.}
}
\value{
A character vector with corresponding
phonetic representation for each entry.
}
\description{
Applies a series of phonetic transformations to a person names vector to
generate code that represents its approximate pronunciation in Brazilian
Portuguese.
The objective is to group similar sounding names, even though written
in different forms.
}
\details{
The treatment process involves:
\enumerate{
\item Preprocessing: Removal of accents, numbers and capitalize.
\item Removal of silent letters (initial H).
\item Simplification of common digraphs (LH, NH, CH, SC, QU, etc.).
\item Simplification of similar sounding consonants (C/K/S, G/J, Z/S, etc.).
\item Simplification of ending nasal sounds.
\item Removal of duplicated vowels.
\item Removal/trim of spaces and duplicated letters.
}
This is an adpation that does not follow strictly any published Metaphone
algorithm, but was inspired by them considering brazilian portuguese
context.
}
\examples{
example_names <- c("Jo\u00e3o Silva", "Joao da Silva", "Maria", "Marya",
                   "Helena", "Elena", "Philippe", "Filipe", "Xavier", "Chavier")
phonetic_codes <- metaphonebr(example_names)
print(data.frame(Original = example_names, metaphonebr = phonetic_codes))

# With progress messages
phonetic_codes_verbose <- metaphonebr("Exemplo único", verbose = TRUE)
}
