% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.split_factors.R
\name{as.split_factors}
\alias{as.split_factors}
\title{Coerce to an object of class split_factors}
\usage{
as.split_factors(x, verbose = TRUE)
}
\arguments{
\item{x}{The input data.}

\item{verbose}{Logical argument. If \code{verbose = FALSE} the code will run
silently.}
}
\value{
An object of class \code{split_factors}.
}
\description{
Functions to coerce an object to a list of class \code{split_factors}, if
possible.
}
\details{
A dataframe may be easily coerced to be split into named subsets based on
each combination of factors existing in the original dataframe. For example,
if the original data has two columns, namely ENV (four levels) and HIB (ten
levels), and ten numeric columns, then using \code{as.split_factors} will
split the data into 40 10-columns subsets, corresponding to each combination
of ENV x HIB.
}
\examples{

library(metan)
spdata = as.split_factors(iris)

spdata2 = as.split_factors(CO2)

is.split_factors(spdata2)

}
