% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/path_coeff.R
\name{plot.path_coeff}
\alias{plot.path_coeff}
\title{Plots an object of class \code{path_coeff}}
\usage{
\method{plot}{path_coeff}(
  x,
  which = "coef",
  size.text.plot = 4,
  size.text.labels = 10,
  digits = 3,
  ...
)
}
\arguments{
\item{x}{An object of class \code{path_coeff} or \code{group_path}.}

\item{which}{Which to plot: one of \code{'coef'}, \code{'vif'}, or \code{'betas'}.}

\item{size.text.plot, size.text.labels}{The size of the text for plot area and
labels, respectively.}

\item{digits}{The significant digits to be shown.}

\item{...}{Further arguments passed on to \code{\link[ggplot2:theme]{ggplot2::theme()}}.}
}
\description{
Plots an object generated by \code{path_coeff()}. Options includes the path
coefficients, variance inflaction factor and the beta values with different
values of 'k' values added to the diagonal of the correlation matrix of
explanatory traits. See more on \code{Details} section.
}
\details{
The plot \code{which = "coef"} (default) is interpreted as follows:
\itemize{
\item The direct effects are shown in the diagonal (highlighted with a thicker
line). In the example, the direct effect of NKE on KW is 0.718.
\item The indirect effects are shown in the line. In the example, the indirect effect of EH on KW through TKW is 0.396.
\item The linear correlation (direct + indirect) is shown in the last column.
}
}
\examples{
\donttest{
library(metan)

# KW as dependent trait and all others as predictors
# PH, EH, NKE, and TKW as predictors

pcoeff <-
  path_coeff(data_ge2,
             resp = KW,
             pred = c(PH, EH, NKE, TKW))
plot(pcoeff)
plot(pcoeff, which = "vif")
plot(pcoeff, which = "betas")
}
}
\author{
Tiago Olivoto \email{tiagoolivoto@gmail.com}
}
