% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_dist.R
\name{get_dist}
\alias{get_dist}
\title{Get a distance matrix}
\usage{
get_dist(..., digits = 2)
}
\arguments{
\item{...}{Object(s) of class \code{clustering}.]}

\item{digits}{The number of significant figures. Defaults to \code{2}.}
}
\value{
A list of class \code{clustering}.
}
\description{
Get the distance matrices from objects fitted with the function
\code{\link{clustering}}. This is especially useful to get distance matrices
from several objects to be further analyzed using \code{\link{pairs_mantel}}.
}
\examples{
\donttest{
library(metan)
d <- data_ge2 \%>\%
      means_by(GEN) \%>\%
      column_to_rownames("GEN") \%>\%
      clustering()
get_dist(d)
}

}
\author{
Tiago Olivoto \email{tiagoolivoto@gmail.com}
}
