% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metapred.R
\name{metapred}
\alias{metapred}
\title{Generalized Stepwise Regression for prediction models}
\usage{
metapred(data, strata, formula = NULL, estFUN = "glm", stepwise = TRUE,
  center.out = FALSE, center.cov = FALSE, recal.int = FALSE,
  cvFUN = NULL, cv.k = NULL, metaFUN = NULL, meta.method = "REML",
  predFUN = NULL, perfFUN = NULL, genFUN = NULL, selFUN = "which.min",
  ...)
}
\arguments{
\item{data}{data.frame containing the datasets.}

\item{strata}{Name of the strata (e.g. studies or clusters) variable, as character. Used for two-stage MA only.}

\item{formula}{Formula of the full model to be evaluated, and possibly reduced. If not supplied,
it is assumed the first column in the data set is the outcome, and all remaining columns
(except \code{strata}) are predictors. See \link[stats]{formula} for details.}

\item{estFUN}{Function for estimating the model in the first stage. Currently "lm" and "glm" are supported.}

\item{stepwise}{Logical. Should stepwise selection be performed?}

\item{center.out}{Logical. Should the outcome be centered within studies?}

\item{center.cov}{Logical. Should covariates be centered within studies?}

\item{recal.int}{Logical. Should the intercept be recalibrated?}

\item{cvFUN}{Cross-validation method, on the study (i.e. cluster or stratum) level. "
l1o" for leave-one-out cross-validation (default). "bootstrap" for bootstrap. Or "fixed", for one or more data sets
which are only used for validation. A user written function may be supplied as well.}

\item{cv.k}{Parameter for cvFUN. For \code{cvFUN="bootstrap"}, this is the number of bootstraps. For \code{cvFUN="fixed"}, 
this is a vector of the indices of the (sorted) data sets.}

\item{metaFUN}{Function for computing the meta-analytic coefficient estimates in two-stage MA. Default: \link[metafor]{rma}
from the metafor package is used. Default settings are univariate random effects, estimated with "REML". Method can be
passed trough the \code{meta.method} argument.}

\item{meta.method}{Name of method for meta-analysis. Default is "REML". For more options see \link[metafor]{rma}.}

\item{predFUN}{Function for predicting new values. Defaults to the appropriate link functions for two-stage MA where
\code{glm()} or \code{lm()} is used in the first stage. For one-stage models \code{predict()} is used.}

\item{perfFUN}{Function for computing the performance of the prediction models. Default: mean squared error.}

\item{genFUN}{Function computing generalizability measure using the performance measures. Default: (absolute) mean.
\code{squareddiff} for a penalty equal to the mean squared differences between coefficients.}

\item{selFUN}{Function for selecting the best method. Default: lowest value for \code{genFUN}. Should be set to
"which.max" if high values for \code{genFUN} indicate a good model.}

\item{...}{To pass arguments to estFUN (e.g. family = "binomial"), or other methods.}
}
\value{
\code{metapred} A list of class \code{metapred}, containing the final coefficients in \code{coefficients}, and the stepwise
tree of estimates of the coefficients \code{(coef)}, performance measures \code{(perf)}, generalizability measures
\code{(gen)} in \code{stepwise}, and more.
}
\description{
Generalized stepwise regression for obtaining a prediction model with adequate performance across data sets. Requires
data from individuals in multiple studies.
}
\examples{
data(DVTipd)
DVTipd$cluster <- 1:4 # Add a fictional clustering to the data set.
metamisc:::metapred(DVTipd, strata = "cluster", f = dvt ~ sex + vein + malign, family = binomial)

\dontrun{
# Some additional examples:
metamisc:::metapred(DVTipd, strata = "cluster", f = dvt ~ sex + vein + malign
, family = binomial, stepwise = FALSE)
metamisc:::metapred(DVTipd, strata = "cluster", f = dvt ~ sex + altdiagn + histdvt
, family = binomial, recal.int = TRUE)
metamisc:::metapred(DVTipd, strata = "cluster", f = dvt ~ sex + altdiagn + histdvt
, family = binomial, meta.method = "DL")
}
# By default, metapred assumes the first column is the outcome.
DVTipd.reordered <- DVTipd[c("dvt", "ddimdich", "histdvt", "cluster")]
mp <- metamisc:::metapred(DVTipd.reordered, strata = "cluster", family = binomial)
fitted <- predict(mp, newdata = DVTipd.reordered)


}
\references{
Debray TPA, Moons KGM, Ahmed I, Koffijberg H, Riley RD. A framework for developing, implementing, 
and evaluating clinical prediction models in an individual participant data meta-analysis. 
\emph{Stat Med}. 2013;32(18):3158-80.
}
\author{
Valentijn de Jong
}
