% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/es_from_USER.R
\name{es_from_user_crude}
\alias{es_from_user_crude}
\title{Directly input a value + variance of an effect size measure}
\usage{
es_from_user_crude(
  measure,
  user_es_measure_crude,
  user_es_crude,
  user_se_crude,
  user_ci_lo_crude,
  user_ci_up_crude
)
}
\arguments{
\item{measure}{the effect size measure used in calculations (must be one of the 11 effect size measures available in metaConvert)}

\item{user_es_measure_crude}{the name of the effect size measure that will appear when this function is called by the \link{convert_df} function (can be any character string)}

\item{user_es_crude}{effect size value}

\item{user_se_crude}{standard error of the effect size}

\item{user_ci_lo_crude}{lower bound of the 95\% CI around the effect size value}

\item{user_ci_up_crude}{upper bound of the 95\% CI around the effect size value}
}
\value{
This function allows to directly input any of the 11 effect size measures

\tabular{ll}{
\code{natural effect size measure} \tab Any of the 11 available measures\cr
\tab \cr
\code{converted effect size measure} \tab No conversion performed\cr
\tab \cr
\code{required input data} \tab See 'Section 23. User's input (crude)'\cr
\tab https://metaconvert.org/html/input.html\cr
\tab \cr
}
}
\description{
Directly input a value + variance of an effect size measure
}
\details{
This function is a generic function allowing to include any crude effect size measure value + variance.
Importantly, with this function, no conversions are performed (i.e., the effect size value + variance
you enter is the value + variance exported by this function).
}
\examples{
dat = data.frame(measure = "OR", user_es_measure_crude = "mortality rate ratio",
                 user_es_crude = -0.04, user_se_crude = 0.2)
summary(convert_df(dat, measure="logor"))
}
