% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/es_from_PHI_CHISQ.R
\name{es_from_phi}
\alias{es_from_phi}
\title{Convert a phi value to several effect size measures}
\usage{
es_from_phi(phi, n_cases, n_exp, n_sample, reverse_phi)
}
\arguments{
\item{phi}{phi value}

\item{n_cases}{total number of cases/events}

\item{n_exp}{total number of participants in the exposed group}

\item{n_sample}{total number of participants in the sample}

\item{reverse_phi}{a logical value indicating whether the direction of generated effect sizes should be flipped.}
}
\value{
This function estimates and converts between several effect size measures.

\tabular{ll}{
\code{natural effect size measure} \tab OR + RR + NNT\cr
\tab \cr
\code{converted effect size measure} \tab D + G + R + Z \cr
\tab \cr
\code{required input data} \tab See 'Section 8. Phi or chi-square'\cr
\tab https://metaconvert.org/html/input.html\cr
\tab \cr
}
}
\description{
Convert a phi value to several effect size measures
}
\details{
The functions computes an odds ratio (OR), risk ratio (RR), and number needed to treat (NNT)
from the the phi coefficient, the total number of participants,
the total number of cases and the total number of people exposed.
Cohen's d (D) and Hedges' g (G) are tried to be obtained from the OR, or are converted
using the approach by Lipsey et al. (2001).
The correlation coefficients (R/Z) are converted by assuming that the phi coefficient
is equal to a R, and the variances of R and Z are obtained using the approach proposed
by Lipsey et al. (2001) as well as by our own calculations.

\strong{To estimate the OR, RR, NNT,},
this function reconstructs a 2x2 table (using the approach proposed by Viecthbauer, 2023).

Then, the calculations of the \code{\link{es_from_2x2}()} function are applied.

\strong{To estimate the Cohen's d (D) and Hedges' g (G)}, the function first tries to convert it from
the OR obtained using the approach described above. If not possible (e.g., the number of cases and exposed are missing)
the function converts the Cohen's d from the Phi coefficient using the approach proposed by Lipsey et al. (2001):
\deqn{d = \frac{2 * phi}{\sqrt{1 - phi^2}}}
\deqn{d\_se = \sqrt{\frac{d}{phi^2 * n\_sample}}}

\strong{To estimate the correlation coefficients (R/Z)}, this function assumes that the
phi coefficient is equal to a correlation coefficient, and then obtains the variance using the
formula proposed by Lipsey et al. (2001):
\deqn{r = phi}
\deqn{z = atanh(r)}
\deqn{z\_se = \frac{z^2}{phi^2 * n\_sample}}
\deqn{effective\_n = \frac{1}{z\_se + 3}}
\deqn{r\_se = \sqrt{\frac{(1 - r^2)^2}{effective\_n - 1}}}

Note that the approach to determine the standard error of R was developed by our team.
}
\examples{
es_from_phi(phi = 0.3, n_sample = 120, n_cases = 20, n_exp = 40)
}
\references{
Viechtbauer (2023). Accessed at https://wviechtb.github.io/metafor/reference/conv.2x2.html.
Lipsey, M. W., & Wilson, D. B. (2001). Practical meta-analysis. Sage Publications, Inc.
}
