% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlrcs.R
\name{mlrcs}
\alias{mlrcs}
\title{Fit multi-level restricted cubic spline model}
\usage{
mlrcs(formula, random = NULL, data, ...)
}
\arguments{
\item{formula}{A model formula for the fixed-effects in the model. Must include one restricted cubic spline term, specified as \code{rcs(variable, df = #)}.}

\item{random}{A formula for the random-effects in the model. Random-effects should be specified as a one-sided formula, e.g. \code{~ 1 + trt | id} for random effect on the intercept and treatment at the \code{id} level. Random-effects can be estimated at any number of nested random-effect levels by providing a list of one-sided formulas. When specifying random-effect at multiple levels. The one-sided formula should be given in order, starting with the highest level.
Only required when \code{rcs = TRUE}.}

\item{data}{A data frame containing all variables required for fitting the model.}

\item{...}{Further arguments passed to \link{merlin}.}
}
\value{
An object of class \code{mlrcs}.
}
\description{
Fit multi-level restricted cubic spline model
}
\examples{
\dontrun{
# Two-level model
data("pbc.merlin", package = "merlin")
fit <- mlrcs(formula = logp ~ 1 + rcs(year, df = 4) + age + trt,
             random  = ~ 1 + trt | id,
             data = pbc.merlin
)
summary(fit)

# Three-level model
fit <- mlrcs(formula = logp ~ 1 + rcs(year, df = 4) + age + trt,
             random  = list(~ 1 | region,
                            ~ 1 + trt | id),
             data = pbc.merlin
)
summary(fit)
}


}
