% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ratio_test.R
\name{ratio_test}
\alias{ratio_test}
\title{Ratio-based test against a change in persistence}
\usage{
ratio_test(x, trend = c("none", "linear"), tau = 0.2,
  statistic = c("mean", "max", "exp"), type = c("BT", "LT", "HLT",
  "HLTmin"), m = 0, z = 9, simu = 0, M = 10000)
}
\arguments{
\item{x}{the univariate numeric time series to be investigated.}

\item{trend}{whether the time series exhibits a trend, \code{none} implies no trend and \code{linear} implies a linear trend.}

\item{tau}{the function tests in the interval \code{[T*tau,T*(1-tau)]} for a break in persistence with T being the length of the time series. It must hold that \code{0<tau<0.5}, default is \code{tau=0.2} as commonly used in the literature.}

\item{statistic}{which type of test statistic should be used, \code{mean} corresponds to Hansen's (1991) mean score, \code{max} to Andrews' (1993) maximum statistic, and \code{exp} to Andrews and Ploberger's (1994) mean-exponential statistic}

\item{type}{which type of ratio test should be performed, \code{BT} for the standard ratio test by Busetti and Taylor (2004), \code{LT} for the modified ratio test by Leybourne and Taylor (2004), and \code{HLT} respectively \code{HLTmin} are the modified tests by Harvey, Leybourne, and Taylor (2006). See details.}

\item{m}{Number of covariances used for the estimation of the long run variance if \code{LT} is considered. Default is \code{m=0}.}

\item{z}{Number of polynomials used if \code{HLT} or \code{HLTmin} are considered. Default is \code{z=9}.}

\item{simu}{whether critical values should be simulated or interpolated, \code{simu=1} means simulation, \code{simu=0} means interpolation based on critical values for \code{tau=0.2}. See details. Default is \code{simu=0}.}

\item{M}{number of replications in case critical values should be simulated. Default is \code{M=10000}.}
}
\value{
Returns a matrix that consists of test statistic and critical values (corresponding to \code{alpha=0.1,0.05,0.01}) for testing against a change from I(1) to I(0), I(0) to I(1), and against a change in an unknown direction.
}
\description{
This function performs a ratio-based test against a change in persistence. Under the null hypothesis the time series is I(0) throughout and
under the alternative a change from either I(1) to I(0) or I(0) to I(1) has occured.
}
\details{
Busetti and Taylor (2004) (BT) introduced a test that is able to identify when time series
exhibit changes in persistence. Under the null
hypothesis, the series is constant I(0), i.e. stationary. Under the alternative the series exhibits a
break either from I(0) to I(1) or I(1) to I(0). As the test is oversized for weakly dependent time series,
Leybourne and Taylor (2004) (LT) standardized the test statistic by an estimate of the long run variance using m lags.
Another problem is that constant I(1) processes are neither covered under the null nor the alternative.
Here, the test often rejects the null although no change in persistence occured.
Harvey, Leybourne, and Taylor (2006) (HLT) introduced a modification where they multiply the test statistic by
a unit root test. This allows the test statistic to have the same critical values under both constant I(0) and constant I(1).
It should be noted, however, that only the critical values are identical, the distribution is highly irregular.

The critical values of the tests vary with the sample size. If \code{simu=0}, the critical values provided
are based on linear interpolation of the critical values simulated by Harvey, Leybourne, and Taylor (2006). These are based on \code{tau=0.2}. If \code{simu=1},
the critical values are simulated based on the given setup using M replications. Caution, for large M this might take a while,
small M, however, make the results unreliable.
}
\examples{
series<- c(rnorm(200),cumsum(rnorm(200)))
ratio_test(series,trend="none",type="BT",statistic="mean")
}
\references{
Busetti, F. and Taylor, R. (2004): Tests of stationarity against a change in persistence. Journal of Econometrics, 123, pp. 33-66.

Leybourne, S. and Taylor, R. (2004): On tests for changes in persistence. Economics letters, 84, pp. 107-115.

Harvey, D., Leybourne, S. and Taylor, R. (2006): Modified tests for a change in persistence. Journal of Econometrics, 134, pp. 441-469.
}
\author{
Janis Becker
}
