% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/getOptim-methods.R
\name{getOptim}
\alias{getOptim}
\alias{getOptim,EL-method}
\alias{getOptim,ELT-method}
\title{Optimization results}
\usage{
\S4method{getOptim}{EL}(object, ...)

\S4method{getOptim}{ELT}(object, ...)
}
\arguments{
\item{object}{An object that inherits from \linkS4class{EL} or
\linkS4class{ELT}.}

\item{...}{Further arguments passed to methods.}
}
\value{
A list with the following optimization results:
  * `par` A numeric vector of the parameter value. See the documentation of
  \linkS4class{EL} and \linkS4class{CEL}.
  * `lambda` A numeric vector of the Lagrange multipliers.
  * `iterations` A single integer for the number of iterations performed.
  * `convergence` A single logical for the convergence status.
}
\description{
Extracts optimization results from a model.
}
\examples{
data("precip")
fit <- el_mean(precip, par = 40)
getOptim(fit)
}
\seealso{
\linkS4class{EL}, \linkS4class{CEL}, \linkS4class{ELT}, [sigTests()]
}
