% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/critVal-methods.R
\name{critVal}
\alias{critVal}
\alias{critVal,ELT-method}
\alias{critVal,ELMT-method}
\title{Critical value}
\usage{
\S4method{critVal}{ELT}(object, ...)

\S4method{critVal}{ELMT}(object, ...)
}
\arguments{
\item{object}{An object that inherit from \linkS4class{ELT} or
\linkS4class{ELMT}.}

\item{...}{Further arguments passed to methods.}
}
\value{
A single numeric.
}
\description{
Extracts critical value from a model.
}
\examples{
## F-calibrated critical value
set.seed(533414)
x <- rnorm(100)
fit <- el_mean(x, 0)
elt <- elt(fit, rhs = 0.3, calibrate = "f")
critVal(elt)
}
