% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/confint-methods.R
\name{confint}
\alias{confint}
\alias{confint,EL-method}
\title{Confidence intervals for model parameters}
\usage{
\S4method{confint}{EL}(
  object,
  parm,
  level = 0.95,
  ...,
  cv = qchisq(level, 1L),
  control = el_control()
)
}
\arguments{
\item{object}{A fitted \linkS4class{EL} object.}

\item{parm}{A specification of which parameters are to be given confidence
intervals, either a vector of numbers or a vector of names. If missing, all
parameters are considered.}

\item{level}{A confidence level required. Defaults to \code{0.95}.}

\item{...}{Not used.}

\item{cv}{A critical value for calibration of empirical likelihood ratio
statistic. Defaults to \code{qchisq(level, 1L)}.}

\item{control}{A list of control parameters set by \code{\link{el_control}}.}
}
\value{
A matrix with columns giving lower and upper confidence limits for
 each parameter. In contrast to other methods that rely on studentization,
 the lower and upper limits obtained from empirical likelihood do not
 correspond to the \code{(1 - level) / 2} and \code{1 - (1 - level) / 2} in
 \%, respectively.
}
\description{
Computes confidence intervals for one or more parameters in a fitted model.
Package \strong{melt} adds a method for objects inheriting from class
\linkS4class{EL}.
}
\examples{
fit <- el_lm(formula = mpg ~ wt, data = mtcars)
confint(fit)
}
\references{
Kim, E., MacEachern, S., and Peruggia, M., (2021),
  "Empirical Likelihood for the Analysis of Experimental Designs,"
  \href{https://arxiv.org/abs/2112.09206}{arxiv:2112.09206}.

Owen, Art. 1990. “Empirical Likelihood Ratio Confidence Regions.”
  The Annals of Statistics 18 (1): 90–120. \doi{10.1214/aos/1176347494}.
}
\seealso{
\link{confreg}, \link{el_control}, \link{lht}
}
