% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/icd9cm.R
\name{icd9cm_elixhauser_quan}
\alias{icd9cm_elixhauser_quan}
\title{Create Quan map of ICD-9-CM to Elixhauser comorbidities}
\usage{
icd9cm_elixhauser_quan(icd9)
}
\arguments{
\item{icd9}{a unique character vector of ICD-9-CM codes}
}
\value{
A data frame, with ICD9 codes as row names and one logical column for each 
comorbidity in \code{\link{elixhauser_list}}
}
\description{
Function to make a dataframe that links ICD-9-CM codes to the Elixhauser comorbidity 
categories using the Quan mapping.
}
\details{
Uses regular expressions created from the Quan paper from 2005.

ICD-9-CM codes must have periods removed.  Diagnostic codes are prefixed with 
'D' while procedure codes are prefixed with 'P'. So, diagnostic code
\code{404.03} should be \code{"D40403"}.

Some ICD-9-CM codes will correspond to more than one category.  For example, 
\code{404.03} (Hypertensive heart and chronic kidney disease ... stage V) is 
in both \code{chf} and \code{renlfail} categories.
}
\examples{
# Identify Elixhauser categories
cases <- data.frame(id=c(1,1,1,2,2,2),
  icd9cm=c("D20206","D24220","D4439","D5064","DE8788","D40403"))
cases_with_cm <- merge(cases, icd9cm_elixhauser_quan(levels(cases$icd9cm)), 
  by.x="icd9cm", by.y="row.names", all.x=TRUE)

# generate crude comorbidity summary for each patient
library(plyr)
ddply(cases_with_cm, .(id), 
  function(x) { data.frame(lapply(x[,3:ncol(x)], any)) })
}
\references{
1. Quan H, Sundararajan V, Halfon P, Fong A, Burnand B, Luthi 
  J-C, Saunders LD, Beck CA, Feasby TE, Ghali WA: Coding algorithms for 
  defining comorbidities in ICD-9-CM and ICD-10 administrative data. Medical 
  care 2005; 43:1130-9 
  \url{http://www.ncbi.nlm.nih.gov/pubmed/16224307}
}
\seealso{
\code{\link{icd9cm_charlson_deyo}}, \code{\link{icd9cm_charlson_romano}},
   \code{\link{icd9cm_charlson_quan}}, \code{\link{icd9cm_elixhauser_ahrq37}}
}

