% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/defaultSoilParams.R
\name{defaultSoilParams}
\alias{defaultSoilParams}
\title{Default soil parameters}
\usage{
defaultSoilParams(n = 4)
}
\arguments{
\item{n}{An integer with the number of soil layers (between two and five).}
}
\value{
A data frame with layers in rows and the following columns (and default values):
\itemize{
  \item{\code{widths (= c(300,700,1000,2000)}: Width of soil layers (in mm).}
  \item{\code{clay (= 25)}: Clay percentage for each layer (in \%).}
  \item{\code{sand (= 25)}: Sand percentage for each layer (in \%).}
  \item{\code{om (= NA)}: Organic matter percentage for each layer (in \%).}
  \item{\code{bd (= 1.5)}: Bulk density for each layer (in g/cm3).}
  \item{\code{rfc (= c(20,40,60,85))}: Percentage of rock fragment content (volume basis) for each layer.}
}
}
\description{
Creates a data frame with default soil physical description for model functions
}
\details{
The function returns a data frame with default physical soil description, with soil layers in rows. 
Users can change those that need to be set to other values and use the list as input for function \code{\link{soil}}.
}
\note{
While this function is limited to five soil layers, user defined data frames can discretize soils using an unlimited number of soil layers.
}
\examples{
defaultSoilParams(4)

}
\seealso{
\code{\link{soil}},  \code{\link{defaultControl}}, \code{\link{SpParamsMED}}
}
\author{
Miquel De \enc{Cáceres}{Caceres} Ainsa, CREAF
}
