% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raw_data.R
\name{raw_data}
\alias{raw_data}
\title{Get paths to \code{mctq} raw datasets}
\usage{
raw_data(file = NULL)
}
\arguments{
\item{file}{(optional) a \code{character} object indicating the raw data file
name(s). If \code{NULL}, all raw data file names will be printed (default:
\code{NULL}).}
}
\value{
\itemize{
\item If \code{file = NULL}, a \code{character} object with all file names available.
\item If \code{file != NULL}, a string with the file name path.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#maturing}{\figure{lifecycle-maturing.svg}{options: alt='[Maturing]'}}}{\strong{[Maturing]}}

\code{mctq} comes bundled with raw fictional datasets for testing and learning
purposes. \code{raw_data()} makes it easy to access their paths.
}
\examples{
\dontrun{
## To list all raw data file names available

raw_data()

## To get the file path from a specific raw data

raw_data(raw_data()[1])

raw_data("std_mctq.csv")}
}
\seealso{
Other utility functions: 
\code{\link{assign_date}()},
\code{\link{cycle_time}()},
\code{\link{pretty_mctq}()},
\code{\link{qplot_walk}()},
\code{\link{random_mctq}()},
\code{\link{round_time}()},
\code{\link{shorter_interval}()},
\code{\link{sum_time}()}
}
\concept{utility functions}
