% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcse_initseq.R
\name{mcse.initseq}
\alias{mcse.initseq}
\title{Multivariate Monte Carlo standard errors for expectations with the initial sequence method of Dai
and Jones (2017)}
\usage{
mcse.initseq(x, g = NULL, adjust = FALSE, blather = FALSE)
}
\arguments{
\item{x}{A matrix or data frame of Markov chain output. Number of rows is the Monte
Carlo sample size.}

\item{g}{A function that represents features of interest. \code{g} is applied to each row of x and
thus \code{g} should take a vector input only. If \code{g} is \code{NULL}, \code{g} is set to be identity, which
is estimation of the mean of the target density.}

\item{adjust}{Logical; if \code{TRUE}, an adjustment is made to increase slightly the eigenvalues of
the initial sequence estimator. The default is \code{FALSE}.}

\item{blather}{if \code{TRUE}, outputs under the hood information about the function.}
}
\value{
A list is returned with the following components,
 \item{cov}{a covariance matrix estimate using intial sequence method.}
 \item{cov.adj}{a covariance matrix estimate using adjusted initial sequence method if the
 input \code{adjust=TRUE}.}
 \item{eigen_values}{eigen values of the estimate cov.}
  \item{method}{method used to calculate matrix cov.}
  \item{est}{estimate of g(x).}
  \item{nsim}{number of rows of the input x. Only if \code{blather = TRUE}.}
  \item{Adjustment_Used}{logical of whether an adjustment was made to the initial sequence estimator.
  Only if \code{blather = TRUE}.}
}
\description{
Function returns the estimate of the covariance matrix in the Markov Chain central limit theorem
using initial sequence method. This method is designed to give an asymptotically conservative
estimate of the Monte Carlo standard error.
}
\examples{

## Bivariate Normal with mean (mu1, mu2) and covariance sigma
n <- 1e3
mu <- c(2, 50)
sigma <- matrix(c(1, 0.5, 0.5, 1), nrow = 2)
out <- BVN_Gibbs(n, mu, sigma)

out.mcse <- mcse.initseq(x = out)
out.mcse.adj <- mcse.initseq(x = out, adjust = TRUE)

# If we are only estimating the mean of the first component,
# and the second moment of the second component
g <- function(x) return(c(x[1], x[2]^2))
out.g.mcse <- mcse.initseq(x = out, g = g)

}
\references{
Dai, N and Jones, G.L. (2017)  Multivariate initial sequence estimators in Markov chain Monte Carlo, 
\emph{ Journal of Multivariate Analysis}, \bold{159}, 184-199.
}
\seealso{
\code{\link{mcse}}, which acts on a vector. 
\code{\link{mcse.mat}}, which applies \code{mcse} to each
column of a matrix or data frame. 
\code{\link{mcse.q}} and \code{\link{mcse.q.mat}}, which compute standard errors for quantiles. 
\code{mcse.multi}, which estimates the covariance matrix in the
Markov Chain CLT using batch means or spectral variance methods.
}
