% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmcse.R
\name{estvssamp}
\alias{estvssamp}
\title{Create a plot that shows how Monte Carlo estimates change with increasing sample size.}
\usage{
estvssamp(x, g = mean, main = "Estimates vs Sample Size", add = FALSE, ...)
}
\arguments{
\item{x}{a sample vector.}

\item{g}{a function such that \eqn{E(g(x))} is the quantity of interest. The default is \code{g =
\link{mean}}.}

\item{main}{an overall title for the plot. The default is \dQuote{\code{Estimates vs Sample
Size}}.}

\item{add}{logical. If \code{TRUE}, add to a current plot.}

\item{\dots}{additional arguments to the plotting function.}
}
\value{
\code{NULL}
}
\description{
Create a plot that shows how Monte Carlo estimates change with increasing sample size.
}
\examples{
## Bivariate Normal with mean (mu1, mu2) and covariance sigma
n <- 1e3
mu <- c(2, 50)
sigma <- matrix(c(1, 0.5, 0.5, 1), nrow = 2)

out <- BVN_Gibbs(n, mu, sigma)

estvssamp(out[,1], main = expression(E(x[1])))
}
