% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emoa_operators.R
\name{mutEdgeExchange}
\alias{mutEdgeExchange}
\title{One-edge-exchange mutator for edge list representation of spanning trees.}
\usage{
mutEdgeExchange(ind, p = 1/ncol(ind))
}
\arguments{
\item{ind}{[\code{matrix(2, m)}]\cr
Matrix of edges (each column is one edge).}

\item{p}{[\code{numeric(1)}]\cr
Probability of edge exchange.
Default is \code{1 / ncol(ind)}.}
}
\value{
[\code{matrix(2, m)}] Mutated edge list.
}
\description{
Each edge is replaced with another feasible edge with probability p.
By default p = 1/m where m is the number of edges, i.e., in expectation one edge
is replaced. The operators maintains the spanning tree property, i.e., the resulting
edge list is indeed the edge list of a spanning tree.
}
\seealso{
Evolutionary multi-objective algorithm \code{\link{mcMSTEmoaBG}}

Other mcMST EMOA mutators: \code{\link{mutSubgraphMST}},
  \code{\link{mutUniformPruefer}}
}
