% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trim.R
\name{trim_rows_cols}
\alias{trim_rows_cols}
\title{Trim rows and/or columns from a matrix}
\usage{
trim_rows_cols(a = NULL, mat = NULL, margin = c(1, 2))
}
\arguments{
\item{a}{A matrix to be trimmed.}

\item{mat}{The matrix}

\item{margin}{The dimension of \code{a} to be trimmed. \code{1} means rows; \code{2} means columns.
Default is \code{c(1,2)}.}
}
\value{
Matrix \code{a} with rows or columns trimmed to match \code{mat}.
}
\description{
By default, the \code{matsbyname} package expends matrices
with \code{0} rows or columns prior to matrix operations
to ensure that rows and columns match.
There are times when trimming rows or columns is preferred
over the default behavior.
This function trims rows or columns in \code{a} to match
the rows or columns of \code{mat}.
The return value will have rows or columns of \code{a} removed if they do not appear in \code{mat}.
}
\details{
If \code{a} is \code{NULL}, \code{NULL} is returned.
If \code{mat} is \code{NULL}, \code{a} is returned unmodified.
If \code{mat} has \code{NULL} dimnames, \code{a} is returned unmodified.
If \code{mat} has \code{NULL} for dimnames on \code{margin}, an error is returned.
}
\examples{
a <- matrix(c(1, 2, 3, 
              4, 5, 6, 
              7, 8, 9), nrow = 3, ncol = 3, byrow = TRUE, 
            dimnames = list(c("r1", "r2", "r3"), c("c1", "c2", "c3"))) \%>\% 
 setrowtype("rowtype") \%>\% setcoltype("coltype")
mat <- matrix(c(1, 2, 3,
              4, 5, 6), nrow = 2, ncol = 3, byrow = TRUE, 
            dimnames = list(c("r1", "bogus"), c("c1", "bogus", "c2"))) \%>\% 
 setrowtype("rowtype") \%>\% setcoltype("coltype")
trim_rows_cols(a, mat, margin = 1)
trim_rows_cols(a, mat, margin = 2)
trim_rows_cols(a, mat)
}
