% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fvar.R
\name{fvar}
\alias{fvar}
\alias{row_f_var}
\alias{col_f_var}
\title{F Variance test}
\usage{
row_f_var(x, y, ratio = 1, alternative = "two.sided", conf.level = 0.95)

col_f_var(x, y, ratio = 1, alternative = "two.sided", conf.level = 0.95)
}
\arguments{
\item{x}{numeric matrix.}

\item{y}{numeric matrix for the second group of observations.}

\item{ratio}{- hypothesized 'x' and 'y' variance ratio.
A single number or numeric vector with values for each observation.}

\item{alternative}{alternative hypothesis to use for each row/column of x.
A single string or a vector with values for each observation.
Values must be one of "two.sided" (default), "greater" or "less".}

\item{conf.level}{confidence levels used for the confidence intervals.
A single number or a numeric vector with values for each observation.
All values must be in the range of [0:1].}
}
\value{
a data.frame where each row contains the results of the F variance
test performed on the corresponding row/column of x and y.\cr\cr
Each row contains the following information (in order):\cr
1. obs.x - number of x observations\cr
2. obs.y - number of y observations\cr
3. obs.tot - total number of observations\cr
4. var.x - variance of x\cr
5. var.y - variance of y\cr
6. var.ratio - x/y variance ratio\cr
7. df.num - numerator degrees of freedom\cr
8. df.denom - denominator degrees of freedom\cr
9. statistic - F statistic\cr
10 pvalue - p-value\cr
11. conf.low - lower bound of the confidence interval\cr
12. conf.high - higher bound of the confidence interval\cr
13. ratio.null - variance ratio of the null hypothesis\cr
14. alternative - chosen alternative hypothesis\cr
15. conf.level - chosen confidence level
}
\description{
Performs the F test of equality of variances for two normal populations on
each row/column of the two input matrices.
}
\details{
NA values are always ommited.

\code{row_f_var(x, y)} - F-test for variance on rows.
\code{col_f_var(x, y)} - F-test for variance on columns.

Results should be the same as as running \code{var.test(x, y)}
on every row (or column) of \code{x} and \code{y}.
}
\examples{
X <- iris[iris$Species=="setosa",1:4]
Y <- iris[iris$Species=="virginica",1:4]
col_f_var(X, Y)

}
\seealso{
\code{var.test()}
}
\author{
Karolis Koncevičius
}
