% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/equation_base.R, R/system_base.R
\name{variable_names}
\alias{variable_names}
\alias{prefixed_const_variable}
\alias{prefixed_independent_variables}
\alias{prefixed_price_variable}
\alias{prefixed_control_variables}
\alias{prefixed_variance_variable}
\alias{prefixed_quantity_variable}
\alias{prefixed_const_variable,equation_base-method}
\alias{prefixed_independent_variables,equation_base-method}
\alias{prefixed_price_variable,equation_base-method}
\alias{prefixed_control_variables,equation_base-method}
\alias{prefixed_variance_variable,equation_base-method}
\alias{prefixed_quantity_variable,equation_base-method}
\alias{lagged_price_variable}
\alias{price_differences_variable}
\alias{lagged_price_variable,system_base-method}
\alias{price_differences_variable,system_base-method}
\title{Variable name access}
\usage{
prefixed_const_variable(object)

prefixed_independent_variables(object)

prefixed_price_variable(object)

prefixed_control_variables(object)

prefixed_variance_variable(object)

prefixed_quantity_variable(object)

\S4method{prefixed_const_variable}{equation_base}(object)

\S4method{prefixed_independent_variables}{equation_base}(object)

\S4method{prefixed_price_variable}{equation_base}(object)

\S4method{prefixed_control_variables}{equation_base}(object)

\S4method{prefixed_variance_variable}{equation_base}(object)

\S4method{prefixed_quantity_variable}{equation_base}(object)

lagged_price_variable(object)

price_differences_variable(object)

\S4method{lagged_price_variable}{system_base}(object)

\S4method{price_differences_variable}{system_base}(object)
}
\arguments{
\item{object}{An equation object.}
}
\value{
The prefixed variable name(s).
}
\description{
Methods that provide access to the prefixed variable names that the
package uses.

\code{prefixed_const_variable}: The constant coefficient name is
constructed by concatenating the equation prefix with \code{CONST}.

\code{prefixed_independent_variables}: The names of the independent
variables are constructed by concatenating the equation prefix with the column names
of the model's data frame.

\code{prefixed_price_variable}: The price variable name is
constructed by concatenating the equation prefix with the name of the price column.

\code{prefixed_control_variables}: The controls of the equation are the
independent variables without the price variable. Their names are constructed by
concatenating the equation prefix with the name of the price column.

\code{prefixed_control_variables}: The variance variable is
constructed by concatenating the equation prefix with \code{VARIANCE}.

\code{prefixed_quantity_variable}: The quantity variable name is
constructed by concatenating the equation prefix with the name of the quantity
column.

\code{lagged_price_variable}: The lagged price variable name is
constructed by concatenating \code{LAGGED} with the price variable name.

\code{price_differences_variable}: The price difference variable name is
constructed by concatenating the price variable name with \code{DIFF}.
}
\section{Functions}{
\itemize{
\item \code{prefixed_const_variable}: Constant coefficient variable name.

\item \code{prefixed_independent_variables}: Independent variable names.

\item \code{prefixed_price_variable}: Price coefficient variable name.

\item \code{prefixed_control_variables}: Control variable names.

\item \code{prefixed_variance_variable}: Variance variable name.

\item \code{prefixed_quantity_variable}: Quantity variable name.

\item \code{lagged_price_variable}: Lagged price variable name.

\item \code{price_differences_variable}: Price differences variable name.
}}

\keyword{internal}
