% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmarkdown.R
\name{html_format}
\alias{html_format}
\alias{latex_format}
\title{R Markdown output formats}
\usage{
html_format(
  meta = NULL,
  template = NULL,
  options = NULL,
  keep_md = FALSE,
  keep_tex = FALSE,
  latex_engine = "xelatex"
)

latex_format(
  meta = NULL,
  template = NULL,
  options = NULL,
  keep_md = FALSE,
  keep_tex = FALSE,
  latex_engine = "xelatex"
)
}
\arguments{
\item{meta, template, options}{Arguments to be passed to \code{\link{mark}()}.}

\item{keep_md, keep_tex}{Whether to keep the intermediate \file{.md} and
\file{.tex} files generated from \file{.Rmd}.}

\item{latex_engine}{The LaTeX engine to compile \file{.tex} to \file{.pdf}.
This argument and \code{keep_tex} are for \code{latex_format()} only, and
ignored in \code{html_format()}.}
}
\description{
Convenience functions for R Markdown v2 users.
}
\details{
We refer to this \pkg{markdown} package plus \pkg{knitr} as \dQuote{R
Markdown v1}, and the \pkg{rmarkdown} package as \dQuote{R Markdown v2}. The
former uses \pkg{commonmark} to convert Markdown, and the latter uses Pandoc.
However, the latter also accept custom converting tools in addition to
Pandoc. The output formats here provide the custom converting function
\code{\link{mark}()} to \pkg{rmarkdown}, so that users can take advantage of
\code{rmarkdown::render()} and the Knit button in RStudio. It is absolutely
not necessary to rely on \pkg{rmarkdown}. The only point is convenience. If
you do not use \code{rmarkdown::render()} or the Knit button, you can
definitely just call \code{markdown::mark()} directly.
}
