% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regkrige.r
\name{regkrige}
\alias{regkrige}
\title{regkrige}
\usage{
regkrige(
  x = NULL,
  y = NULL,
  z = NULL,
  field = NULL,
  edge = 0,
  filter = 1,
  resolution = NULL,
  md = "Sph",
  rg = NULL,
  ng = 0.1,
  check_data = T
)
}
\arguments{
\item{x}{Raster dataset. Required. Must be have a defined coordinate system.
If the coordinate system is not cartesian, the data will be projected onto
the Web Mercator (epsg: 3857) coordinate system before any analyses/tests.}

\item{y}{SpatialPolygonsDataFrame. Optional. Delineates the area within
which the raster layer shall be locally adapted and evaluted. Must be projected. If not
projected onto the same coordinate system as x, it will be reprojected to the
coordinate system of x. If not provided, the analyses willbe performed within
the intersect of the raster and the sampled area."}

\item{z}{SpatialPointsDataFrame. Required. Must have at least one column
with numerical data and these data must be of the same entity unit as the raster
(specify this column by argument: field). Must be projected. If not
projected to the same coordinate system as x, it will be reprojected to the
coordinate system of x.}

\item{field}{Character value. Required. Name of the column in
y with the data that shall be used to locally adapt and evaluate the raster}

\item{edge}{Numeric value. Optional. Specifies the width (m) of a
buffer zone inside the edge of the polygon that is excluded from the analyses.
Allowed values are within the closed range of 0-10000.}

\item{filter}{Positive integer. Optional. No of cells in the side of a square
window for mean filtering of x. Filtering is done before any resampling
(see argument: resolution). Allowed values are within the closed range of 1-20.}

\item{resolution}{Positive numeric value. Optional. The resolution (m) to
which the imported raster shall be resampled before the adaptation. Allowed
values are within the closed range of 0.1-10000. In addition, a resolution that
means more than 1E+8 raster cells is not allowed.}

\item{md}{Character value. Optional. Variogram model type for the stadardized
variograms used for ordinary kriging interpolation of observed data or residuals.
Variograms are generated by gstat::vgm. Default is "Sph" (spherical model).}

\item{rg}{Numeric value. Optional. Range of the stadardized variograms used
for ordinary kriging interpolation of observed data or residuals. Variograms
are generated by gstat::vgm. If no rg is specified it will be set to half of
the square root of the mapping area: y (possibly shrinked by edge).}

\item{ng}{Numeric value. Optional. Nugget of the stadardized variograms
used for ordinary kriging interpolation of observed data or residuals.
Variograms are  generated by gstat::vgm. The nugget is expressed as a fraction
of the sill. A ng = 0.1 means that the nugget is 10 % of the sill. The sill
is by default equal to the variance of the data to be krigied (i.e the point
observations or the residuals). Allowed values of ng are within the closed
range of 0-1.}

\item{check_data}{Locigal. Shall attributes, geometries and projections of
the input data (arguments x, y and z) be checked. Default = TRUE.}
}
\value{
A list with 1) a raster layer with predicted values and 2) a
SpatialPolygonsDataFrame with cross-validation data. For details, see
mri function.
}
\description{
Regression kriging using a standardized variogram.
}
\details{
This is the regression kriging function called by the mri function.
For details, see documentation of the mri function.
}
