% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats_hub.R
\name{compute_tightness}
\alias{compute_tightness}
\title{Compute dispersion of a single cluster}
\usage{
compute_tightness(dists, cluster)
}
\arguments{
\item{dists}{A distance matrix for points in the cluster.}

\item{cluster}{A list containing named vectors, whose names are data point names and whose values are cluster labels}
}
\value{
A real number in \eqn{[0,1]} representing a measure of dispersion of a cluster.
}
\description{
Compute dispersion of a single cluster
}
\details{
This method computes a measure of cluster dispersion. It finds the medoid of the input data set and returns the average distance to the medoid. Formally, we say the tightness \eqn{\tau} of a cluster \eqn{C} is given by \deqn{\tau(C) = \dfrac{1}{\left(|C|-1\right)}\displaystyle\sum_{i}\text{dist}(x_i, x_j)} where \deqn{x_j = \text{arg}\,\min\limits_{x_j\in C}\, \sum_{x_i \in C, i\neq j}\text{dist}(x_i, x_j)} A smaller value indicates a tighter cluster based on this metric.
}
