% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/func_process_input_data.R
\name{standardise_data}
\alias{standardise_data}
\title{Standardise Input Data}
\usage{
standardise_data(df, type = "admixture")
}
\arguments{
\item{df}{a data.frame.}

\item{type}{type of file to process (\code{"admixture"} or \code{"coordinates"}).}
}
\value{
A data.frame object.
}
\description{
Internal function used to standardise the output from \code{mapmixture::read_input_data()}.
}
\examples{
# Standardise admixture data
df_admix <- data.frame(
  Site = c("London", "London", "Paris", "Paris", "Berlin", "Berlin",
   "Rome", "Rome", "Madrid", "Madrid"),
  Ind = c("London1", "London2", "Paris1", "Paris2", "Berlin1", "Berlin2",
   "Rome1", "Rome2", "Madrid1", "Madrid2"),
  Cluster1 = c(1.0, 0.9, 0.5, 0.5, 0.1, 0.1, 0, 0, 0, 0),
  Cluster2 = c(0, 0.10, 0.50, 0.40, 0.50, 0.40, 0.01, 0.01, 0.70, 0.80),
  Cluster3 = c(0, 0, 0, 0.10, 0.40, 0.50, 0.99, 0.99, 0.30, 0.20)
)
standardise_data(df_admix, type = "admixture")

# Standardise coordinates data
df_coords <- data.frame(
  Site = c("London", "Paris", "Berlin", "Rome", "Madrid"),
  Lat = c(51.51, 48.85, 52.52, 41.90, 40.42),
  Lon = c(-0.12, 2.35, 13.40, 12.49, -3.70)
)
standardise_data(df_coords, type = "coordinates")
}
\keyword{internal}
