% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/register.R, R/get_resources.R,
%   R/calc_indicators.R, R/spatial-utils.R
\name{mapme}
\alias{mapme}
\alias{mapme_options}
\alias{get_resources}
\alias{calc_indicators}
\alias{prep_resources}
\title{Portfolio methods for mapme.biodiversity}
\usage{
mapme_options(..., outdir, chunk_size, retries, verbose, log_dir)

get_resources(x, ...)

calc_indicators(x, ...)

prep_resources(x, avail_resources = NULL, resources = NULL)
}
\arguments{
\item{...}{One or more functions for resources/indicators}

\item{outdir}{A length one character indicating the output path.}

\item{chunk_size}{A numeric of length one giving the maximum chunk area in ha.
Defaults to 100,000 ha. It refers to the area of an asset's bounding box.
If it lies above the value \code{chunk_size}, splitting and chunking is considered.
An asset will be processes as-is with an bounding box area below the specified
value.}

\item{retries}{A numeric of length one indicating the number or re-tries
the package should attempt to make a resource available. Defaults to 3.}

\item{verbose}{A logical, indicating if informative messages should be printed.}

\item{log_dir}{A character path pointing toward a GDAL-writable destination
used to log erroneous assets. Defaults to NULL, meaning that erroneous
assets will not be serialized to disk. If specified, a GPKG named
\code{file.path(log_dir, paste0(Sys.Date(), "_mapme-error-assets.gpkg"))} will
be created and appended to in case of erroneous assets.}

\item{x}{An \code{sf} object with features of type \code{"POLYGON"}}

\item{avail_resources}{A list object of available resources. If NULL (the default),
the available resources will automatically be determined.}

\item{resources}{A character vector with the resources to be prepared. If it
it is NULL (the default) all available resources will be prepared.}
}
\value{
\code{mapme_options()} returns a list of options if no arguments are
specified. Otherwise sets matching arguments to new values in the package's
internal environment.

\code{get_resources()} is called for its side effect of making resources
available in the package environment. Returns \code{x}, invisibly.

\code{calc_indicators()} returns \code{x}, invisibly, with an additional nested
list column per requested indicator.

\code{prep_resources()} returns a list with prepared vector and raster
resources as \code{sf} and \code{SpatRaster}-objects.
}
\description{
\code{mapme_options()} sets default options for mapme.biodiversity to control the
behavior of downstream functions. Mainly, the output path as well as the
chunk size (in ha), can be set. Additionally, the verbosity can be set and
the path to a log directory can be controlled. Might be extended by other
options in the future.

\code{get_resources()} data sets required for the
calculation of indicators can be made available. The function supports the
specification of several resource functions. To determine the output path,
temporary directory and verbosity, the output of \code{mapme_options()} is used.

\code{calc_indicators()} calculates specific biodiversity indicators. A
requirement is that the resources that are mandatory inputs for the requested
indicators are available locally. Multiple indicators and their respective
additional arguments can be supplied.

This function reads and crops available resources to the extent of a single
asset. Specific resources can be queried. If not supplied (the default), all
available resources will be prepared.
}
\examples{
library(mapme.biodiversity)
mapme_options()
}
