% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_temperature_max_wc.R
\docType{data}
\name{temperature_max_wc}
\alias{temperature_max_wc}
\title{Calculate maximum temperature statistics}
\format{
A tibble with a column for maximum temperature statistics (in °C)
}
\description{
This function allows to efficiently calculate maximum temperature statistics
from Worldclim for polygons. For each polygon, the desired statistic/s (min,
max, sum, mean, median, sd or var) is/are returned.
The required resources for this indicator are:
\itemize{
\item maximum temperature layer from \link{worldclim}
}
}
\details{
The following arguments can be set:
\describe{
\item{stats_worldclim}{Function to be applied to compute statistics for polygons either
one or multiple inputs as character. Supported statistics are: "mean",
"median", "sd", "min", "max", "sum" "var".}
\item{engine}{The preferred processing functions from either one of "zonal",
"extract" or "exactextract" as character.}
}
}
\examples{
\dontshow{
mapme.biodiversity:::.copy_resource_dir(file.path(tempdir(), "mapme-data"))
}
\dontrun{
library(sf)
library(mapme.biodiversity)

outdir <- file.path(tempdir(), "mapme-data")
dir.create(outdir, showWarnings = FALSE)

aoi <- system.file("extdata", "sierra_de_neiba_478140_2.gpkg",
  package = "mapme.biodiversity"
) \%>\%
  read_sf() \%>\%
  init_portfolio(
    years = 2018,
    outdir = outdir,
    tmpdir = tempdir(),
    add_resources = FALSE,
    verbose = FALSE
  ) \%>\%
  get_resources("worldclim_max_temperature") \%>\%
  calc_indicators("temperature_max_wc",
    stats_worldclim = c("mean", "median"),
    engine = "extract"
  ) \%>\%
  tidyr::unnest(temperature_max_wc)

aoi
}
}
\keyword{indicator}
