% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_layer_text.R
\name{add_text}
\alias{add_text}
\title{Add Text}
\usage{
add_text(map, data = get_map_data(map), text, lon = NULL, lat = NULL,
  polyline = NULL, fill_colour = NULL, fill_opacity = NULL,
  size = NULL, angle = NULL, anchor = NULL,
  alignment_baseline = NULL, tooltip = NULL, layer_id = NULL,
  id = NULL, auto_highlight = FALSE, highlight_colour = "#AAFFFFFF",
  palette = "viridis", na_colour = "#808080FF", legend = FALSE,
  legend_options = NULL, update_view = TRUE, focus_layer = FALSE,
  transitions = NULL)
}
\arguments{
\item{map}{a mapdeck map object}

\item{data}{data to be used in the layer. All coordinates are expected to be in
Web Mercator Projection}

\item{text}{column of \code{data} containing the text. The data must be a character.}

\item{lon}{column containing longitude values}

\item{lat}{column containing latitude values}

\item{polyline}{optional column of \code{data} containing the polylines, if using encoded polylines}

\item{fill_colour}{column of \code{data} or hex colour for the fill colour.
transition enabled}

\item{fill_opacity}{value between 0 and 255. Either a string specifying the
column of \code{data} containing the fill opacity of each shape, or a single value
to be applied to all the shapes}

\item{size}{column of \code{data} containing the size of the text}

\item{angle}{column of \code{data} containging the angle of the text}

\item{anchor}{column of \code{data} containing the anchor of the text. One of
'start', 'middle' or 'end'}

\item{alignment_baseline}{column of \code{data} containing the alignment. One of
'top', 'center' or 'bottom'}

\item{tooltip}{variable of \code{data} containing text or HTML to render as a tooltip}

\item{layer_id}{single value specifying an id for the layer. Use this value to
distinguish between shape layers of the same type. Layers with the same id are likely
to conflict and not plot correctly}

\item{id}{an id value in \code{data} to identify layers when interacting in Shiny apps.}

\item{auto_highlight}{logical indicating if the shape under the mouse should auto-highlight}

\item{highlight_colour}{hex string colour to use for highlighting. Must contain the alpha component.}

\item{palette}{string or matrix. String will be one of \code{colourvalues::colour_palettes()}.
A matrix is a 3 or 4 column numeric matrix of values between [0, 255],
where the 4th column represents the alpha.}

\item{na_colour}{hex string colour to use for NA values}

\item{legend}{either a logical indiciating if the legend(s) should be displayed, or
a named list indicating which colour attributes should be included in the legend.}

\item{legend_options}{A list of options for controlling the legend.}

\item{update_view}{logical indicating if the map should update the bounds to include this layer}

\item{focus_layer}{logical indicating if the map should update the bounds to only include this layer}

\item{transitions}{list specifying the duration of transitions.}
}
\description{
The Text Layer renders text labels on the map
}
\details{
\code{add_text} supports POINT and MULTIPOINT sf objects
}
\section{transitions}{


The transitions argument lets you specify the time it will take for the shapes to transition
from one state to the next. Only works in an interactive environment (Shiny)
and on WebGL-2 supported browsers and hardware.

The time is in milliseconds

Available transitions for text

list(
position = 0,
fill_colour = 0,
angle = 0,
size = 0
)
}

\section{legend}{


The \code{legend_options} can be used to control the appearance of the legend.
This should be a named list, where the names are one of
\itemize{
  \item{css - a string of valid \code{css} for controlling the appearance of the legend}
  \item{title - a string to use for the title of the legend}
}

If the layer allows different fill and stroke colours, you can use different options for each. See examples in \link{add_arc}.

The \code{legend_format} can be used to control the format of the values in the legend.
This should be a named list, where the names are one of
\itemize{
  \item{fill_colour}
  \item{stroke_colour}
}

depending on which type of colouring the layer supports.

The list elements must be functions to apply to the values in the legend.
}

\section{id}{


The \code{id} is returned to your R session from an interactive shiny environment
by observing layer clicks. This is useful for returning the data.frame row relating to the
cliked shape.

From within a shiny server you would typically use \code{ observeEvent({input$map_arc_click})},
where 'map' is the map_id supplied to \code{mapdeckOutput()}, and 'arc' is the layer
you are clicking on
}

\examples{

\donttest{

## You need a valid access token from Mapbox
key <- 'abc'

mapdeck(
  token = key,
  style = mapdeck_style('dark')
) \%>\%
  add_text(
    data = capitals
    , lon = 'lon'
    , lat = 'lat'
    , fill_colour = 'country'
    , text = 'capital'
    , layer_id = 'text'
  )
}

}
