% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addProviderEspTiles.R
\name{addProviderEspTiles}
\alias{addProviderEspTiles}
\alias{providerEspTileOptions}
\title{Leaflet plugin - Spanish providers}
\source{
\href{https://dieghernan.github.io/leaflet-providersESP/}{leaflet-providersESP}
leaflet plugin, \strong{v1.2.0}.
}
\usage{
addProviderEspTiles(
  map,
  provider,
  layerId = NULL,
  group = NULL,
  options = providerEspTileOptions()
)

providerEspTileOptions(...)
}
\arguments{
\item{map, layerId, group, options}{See \link[leaflet]{addTiles}}

\item{provider}{Name of the provider, see \link{leaflet.providersESP.df}.}

\item{...}{Additional options. See \link[leaflet]{providerTileOptions}.}
}
\value{
Modified \code{map} object.
}
\description{
Add tiles of
\href{https://dieghernan.github.io/leaflet-providersESP/}{leaflet-providersESP}
to a \strong{R} \link[leaflet]{leaflet} map.
}
\details{
\code{providerEspTileOptions} is a wrapper of
\code{leaflet::providerTileOptions}
}
\examples{
library(leaflet)
  PuertadelSol <-
    leaflet() \%>\% setView(lat = 40.4166,
                          lng = -3.7038400,
                          zoom = 18) \%>\%
    addProviderEspTiles(provider = "IGNBase.Gris") \%>\%
    addProviderEspTiles(provider = "RedTransporte.Carreteras")

    PuertadelSol



}
\seealso{
\link{leaflet.providersESP.df}, \link{esp_getTiles}

\link[leaflet]{tileOptions}, \link[leaflet]{providerTileOptions}
}
\author{
dieghernan, \url{https://github.com/dieghernan/}
}
