% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manip_correlation.R
\name{correlation}
\alias{correlation}
\alias{to_correlation}
\title{Node correlation}
\usage{
to_correlation(.data, method = NULL)
}
\arguments{
\item{.data}{An object of a manynet-consistent class:
\itemize{
\item matrix (adjacency or incidence) from \code{{base}} R
\item edgelist, a data frame from \code{{base}} R or tibble from \code{{tibble}}
\item igraph, from the \code{{igraph}} package
\item network, from the \code{{network}} package
\item tbl_graph, from the \code{{tidygraph}} package
}}

\item{method}{One of the following:
"all" includes all information,
"diag" excludes the diagonal (self-ties),
"recip" excludes the diagonal but compares pairs' reciprocal ties,
and "complex" compares pairs' reciprocal ties and their self ties.
By default the appropriate method is chosen based on the network format.}
}
\description{
This function performs a Pearson pairwise correlation on a given matrix or network data.
It includes a switch:
whereas for a two-mode network it will perform a regular correlation,
including all rows,
for an undirected network it will perform a correlation on a matrix
with the diagonals removed,
for a reciprocated network it will include the difference
between reciprocated ties,
and for complex networks it will include also the difference
between the self ties in each pairwise calculation.
This function runs in \eqn{O(mn^2)} complexity.
}
\seealso{
Other modifications: 
\code{\link{add_nodes}()},
\code{\link{add_ties}()},
\code{\link{as}()},
\code{\link{from}},
\code{\link{miss}},
\code{\link{reformat}},
\code{\link{split}()},
\code{\link{to_levels}},
\code{\link{to_paths}},
\code{\link{to_project}},
\code{\link{to_scope}}
}
\concept{modifications}
