% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nicheness.R
\name{mp_nicheness}
\alias{mp_nicheness}
\alias{nicheness_meyer_miller}
\alias{nicheness_bischof}
\title{Party nicheness measures}
\usage{
mp_nicheness(data, method = "bischof", ...)

nicheness_meyer_miller(data, groups = meyer_miller_2013_policy_dimensions(),
  transform = NULL, smooth = FALSE, weights = "pervote",
  party_system_normalization = TRUE, only_non_zero = TRUE)

nicheness_bischof(data, out_variables = c("party", "date", "specialization",
  "nicheness", "nicheness_two"), groups = bischof_issue_groups(),
  diversification_bounds = c(0, rep(1/length(groups), length(groups)) \%>\% { 
     -(. * log(.)) } \%>\% sum()), smooth = function(x) {     (x + lag(x,
  default = first(first(x))))/2 })
}
\arguments{
\item{data}{a dataframe or matrix in format of Manifesto Project Main Dataset}

\item{method}{choose between bischof and meyermiller}

\item{...}{parmaeters passed on to specialized functions for differnet methods}

\item{groups}{groups of issues to determine niches/policy dimensions; formatted as named lists
variable names. For Meyer & Miller: Defaults to adapted version of Baeck et. al 2010 Policy dimensions
(without industry, as used in the original paper by Meyer & Miller). For Bischof: defaults
to issue groups used in the Bischof 2015 paper}

\item{transform}{transform to apply to each of the group indicators. Can be a function,
character "bischof" to apply log(x + 1), or NULL for no transformation.}

\item{smooth}{Smoothing of policy dimension values before nicheness computation, as suggested
and used by Bischof 2015}

\item{weights}{vector of the length nrow(data) or the name of a variable in data; is used to
weight mean party system position and nicheness; defaults to "pervote" as in Meyer & Miller 2013}

\item{party_system_normalization}{normalize nicheness result within election (substract weighted mean nicheness)}

\item{only_non_zero}{When dividing by the number of policy dimensions used for nicheness
estimation, ignore dimensions that are zero for all parties (election-wise)}

\item{out_variables}{names of variables to return in data.frame. Can be any
from the input or that are generated during the computation of Bischof's nicheness
measure. See details for a list.}

\item{diversification_bounds}{Bounds of the range of the diversification measure
(Shannon's entropy $s_p$ in Bischof 2015), used for inversion and normalization;
default to the theoretical bounds of the entropy of a distribution on 5 discrete
elements. If "empirical", the empirical max and min of the diversification measure
are used}
}
\description{
Computes party nicheness measures suggested by Bischof 2015 and Meyer and Miller 2013.
}
\details{
List of possible outputs of \code{nicheness_bischof}:

diversification: Shannon's entropy $s_p$ in Bischof 2015

max_divers: used maximum for diversification

min_divers: used minimum for diversification

specialization: inverted diversification

specialization_stand: standardized specialization

nicheness: nicheness according to Meyer & Miller 2013 without vote share weighting

nicheness_stand: standardized nicheness

nicheness_two: sum of nicheness_stand and specialization_stand as proposed by Bischof 2015
}
\references{
Bischof, D. (2015). Towards a Renewal of the Niche Party Concept Parties, Market Shares and Condensed Offers. Party Politics.

Meyer, T.M., & Miller, B. (2013). The Niche Party Concept and Its Measurement. Party Politics 21(2): 259-271.

Baeck, H., Debus, M., & Dumont, P. (2010). Who gets what in coalition governments? Predictors of portfolio
allocation in parliamentary democracies. European Journal of Political Research 50(4): 441-478.
}
