/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.grmm.types;

import cc.mallet.grmm.types.AbstractFactor;
import cc.mallet.grmm.types.Assignment;
import cc.mallet.grmm.types.AssignmentIterator;
import cc.mallet.grmm.types.Factor;
import cc.mallet.grmm.types.HashVarSet;
import cc.mallet.grmm.types.VarSet;
import cc.mallet.util.Maths;
import cc.mallet.util.Randoms;

public class ConstantFactor
extends AbstractFactor {
    private double c;
    private static final long serialVersionUID = -2934945791792969816L;

    public ConstantFactor(double c) {
        super(new HashVarSet());
        this.c = c;
    }

    @Override
    protected Factor extractMaxInternal(VarSet varSet) {
        return this;
    }

    @Override
    protected double lookupValueInternal(int i) {
        return this.c;
    }

    @Override
    protected Factor marginalizeInternal(VarSet varsToKeep) {
        return this;
    }

    @Override
    public double value(AssignmentIterator it) {
        return this.c;
    }

    @Override
    public Factor normalize() {
        this.c = 1.0;
        return this;
    }

    @Override
    public Assignment sample(Randoms r) {
        return new Assignment();
    }

    @Override
    public String dumpToString() {
        return "[ConstantFactor : " + this.c + " ]";
    }

    public String toString() {
        return this.dumpToString();
    }

    @Override
    public Factor slice(Assignment assn) {
        return this;
    }

    @Override
    public Factor duplicate() {
        return new ConstantFactor(this.c);
    }

    @Override
    public boolean almostEquals(Factor p, double epsilon) {
        return p instanceof ConstantFactor && Maths.almostEquals(this.c, ((ConstantFactor)p).c, epsilon);
    }

    @Override
    public boolean isNaN() {
        return Double.isNaN(this.c);
    }

    @Override
    public Factor multiply(Factor other) {
        if (Maths.almostEquals(this.c, 1.0)) {
            return other.duplicate();
        }
        if (other instanceof ConstantFactor) {
            return new ConstantFactor(this.c * ((ConstantFactor)other).c);
        }
        return other.multiply(this);
    }

    @Override
    public void multiplyBy(Factor other) {
        if (!(other instanceof ConstantFactor)) {
            throw new UnsupportedOperationException("Can't multiply a constant factor by " + other);
        }
        ConstantFactor otherCnst = (ConstantFactor)other;
        this.c *= otherCnst.c;
    }

    public static Factor makeIdentityFactor() {
        return new ConstantFactor(1.0);
    }
}

