/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.grmm.inference;

import cc.mallet.grmm.inference.AbstractBeliefPropagation;
import cc.mallet.grmm.inference.Inferencer;
import cc.mallet.grmm.types.Factor;
import cc.mallet.grmm.types.FactorGraph;
import cc.mallet.grmm.types.Variable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;

public class LoopyBP
extends AbstractBeliefPropagation {
    public static final int DEFAULT_MAX_ITER = 1000;
    private int maxIter;
    private Random rand = new Random();
    private static final long serialVersionUID = 1L;

    public void setUseCaching(boolean useCaching) {
        this.useCaching = useCaching;
    }

    public LoopyBP() {
        this(new AbstractBeliefPropagation.SumProductMessageStrategy(), 1000);
    }

    public LoopyBP(int maxIter) {
        this(new AbstractBeliefPropagation.SumProductMessageStrategy(), maxIter);
    }

    public LoopyBP(AbstractBeliefPropagation.MessageStrategy messager, int maxIter) {
        super(messager);
        this.maxIter = maxIter;
    }

    public static Inferencer createForMaxProduct() {
        return new LoopyBP(new AbstractBeliefPropagation.MaxProductMessageStrategy(), 1000);
    }

    public LoopyBP setRand(Random rand) {
        this.rand = rand;
        return this;
    }

    @Override
    public void computeMarginals(FactorGraph mdl) {
        int iter;
        super.initForGraph(mdl);
        for (iter = 0; iter < this.maxIter; ++iter) {
            logger.finer("***AsyncLoopyBP iteration " + iter);
            this.propagate(mdl);
            if (this.hasConverged()) break;
            this.copyOldMessages();
        }
        this.iterUsed = iter;
        if (iter >= this.maxIter) {
            logger.info("***Loopy BP quitting: not converged after " + this.maxIter + " iterations.");
        } else {
            ++this.iterUsed;
            logger.info("***AsyncLoopyBP converged: " + this.iterUsed + " iterations");
        }
        this.doneWithGraph(mdl);
    }

    private void propagate(FactorGraph mdl) {
        ArrayList factors = new ArrayList(mdl.factors());
        Collections.shuffle(factors, this.rand);
        for (Factor factor : factors) {
            for (Variable from : factor.varSet()) {
                this.sendMessage(mdl, from, factor);
            }
        }
        for (Factor factor : factors) {
            for (Variable to : factor.varSet()) {
                this.sendMessage(mdl, factor, to);
            }
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }
}

