# WARNING - Generated by {fusen} from dev/flat_utils.Rmd: do not edit by hand

#' Remove raw spectra
#'
#' The `remove_spectra()` function is used to discard specific spectra from raw spectra list by removing them.
#'
#' @param spectra_list A list of [MALDIquant::MassSpectrum] objects
#' @param to_remove The spectra to be removed. A logical vector same size of `spectra_list` or from [check_spectra] function
#'
#' @return The same object as `spectra_list` minus the spectra in `to_remove`.
#' @noRd
remove_spectra_logical <- function(spectra_list, to_remove) {
  to_remove_class <- base::unlist(to_remove) %>% base::class()
  if (to_remove_class != "logical") {
    stop(
      "Non logical values in 'to_remove' against expectations\n",
      "You could provide the output of `check_spectra()`."
    )
  }
  to_remove <- switch(base::class(to_remove),
    "list" = Reduce(`|`, to_remove),
    "logical" = to_remove
  )
  if (base::length(spectra_list) != base::length(to_remove)) {
    stop(
      "Unequal lengths between spectra_list and to_remove"
    )
  }
  return(spectra_list[!to_remove])
}
