% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02-dataset_functions.R
\name{dataset_zap_data_dict}
\alias{dataset_zap_data_dict}
\title{Remove labels (attributes) from a data frame, leaving its unlabelled columns}
\usage{
dataset_zap_data_dict(dataset)
}
\arguments{
\item{dataset}{A tibble identifying the input dataset observations
associated to its data dictionary.}
}
\value{
A tibble identifying a dataset.
}
\description{
Removes any attributes attached to a tibble. Any value in columns will be
preserved. Any 'Date' (typeof) column will be recast as character to
preserve information.
}
\details{
A dataset must be a data frame-like object and can be associated with a
data dictionary. If no data dictionary is provided, a minimum workable
data dictionary will be generated as needed by relevant functions.
An identifier \code{id} column for sorting can be specified by the user. If
specified, the \code{id} values must be non-missing and will be used in functions
that require it. If no identifier column is specified, indexing is handled
automatically by the function.
}
\examples{
{

# use DEMO_files provided by the package

dataset <- DEMO_files$dataset_TOKYO
data_dict <- as_data_dict_mlstr(DEMO_files$dd_TOKYO_format_maelstrom_tagged)
dataset <- data_dict_apply(dataset,data_dict)
dataset_zap_data_dict(dataset)

}

}
\seealso{
\code{\link[haven:zap_labels]{haven::zap_labels()}}.
}
