% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tabRisks.R
\name{tabRisks}
\alias{tabRisks}
\title{Calculating Risks and Relative Risks}
\usage{
tabRisks(
  data,
  ...,
  by,
  exp_value = NULL,
  case_value = NULL,
  plot = TRUE,
  na.rm = FALSE,
  rnd = 3
)
}
\arguments{
\item{data}{Dataset}

\item{...}{Variable or multiple variables
Colon separator \code{:} can be used to specify multiple variables.}

\item{by}{Varaiable for cross-tabulation}

\item{exp_value}{value for exposure as reference}

\item{case_value}{value for outcome as reference}

\item{plot}{logical value to display plots of rates across a categorical
variable}

\item{na.rm}{A logical value to specify missing values, \code{NA} in the table}

\item{rnd}{specify rounding of numbers. See \code{\link{round}}.}
}
\description{
\code{tabRisks()} cross-tabulates two variables and
reports risks of failure \code{by} among exposed and
unexposed levels of explanatory variable \code{...}.
It is used in cross-sectional studies.
}
\details{
Risks are sometimes called proportions, incidence proportions or
prevalence.

\strong{Calculating Risks}

\deqn{Risks = Outcome of Interest (A) / Sample Size (n)}

\deqn{Standard Error, SE = \sqrt(p x (1 - p) / n)}

\deqn{95\% CI = Risks +/- (1.96 x SE)}
}
\note{
This method should be avoided in small samples. Quadratic or
exact binomial methods are preferred in this regard.
}
\examples{

## use infert data
data(infert)

tabRisks(infert, education, by = case, case_value = 1, plot = FALSE)
tabRisks(infert, induced, by = case, plot = FALSE)

tabRisks(infert, education, induced, by = case, plot = FALSE)

}
\references{
\enumerate{
\item  Betty R. Kirkwood, Jonathan A.C. Sterne (2006, ISBN:978–0–86542–871–3)
\item B. Burt Gerstman (2013, ISBN:978-1-4443-3608-5)
\item Douglas G Altman (2005, ISBN:0 7279 1375 1)
}
}
\author{
For any feedback, please contact \code{Myo Minn Oo} via:

Email: \email{dr.myominnoo@gmail.com}

Website: \url{https://myominnoo.github.io/}
}
