% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{printText}
\alias{printText}
\alias{printText2}
\alias{printLines}
\alias{printMsg}
\alias{getnPrintLabel}
\alias{wrapText}
\title{Display functions for \code{mStats}}
\usage{
printText(.x, .txt, .split = NULL, .printDF = FALSE)

printText2(.x, .txt, .split = NULL, .printDF = FALSE)

printLines(.x = "=", .width = 80)

printMsg(.txt = NULL)

getnPrintLabel(.data, .var.name)

wrapText(.txt, .width = 70, .sep = "\\n")
}
\arguments{
\item{.x}{vector, matrix, dataframe or separator (in case of printLines)}

\item{.txt}{texts}

\item{.split}{separator for printText}

\item{.printDF}{If yes, print as Data.frame}

\item{.width}{desired character length to display}

\item{.data}{Dataset}

\item{.var.name}{Variable name to retrieve label}

\item{.sep}{separator for line break}
}
\description{
Printing Functions to format and display outputs from mStats package

\code{printText}, an old version of \code{printText2} which produces
a better output.

\code{printText2()} can print data.frame in a well-formatted style.
This added printLines for better visualization.

\code{printLines()} produces lines as strings for specified length.

\code{printMsg()} produces any text withint two round brackets.

\code{getnPrintLabel()} extract labels and printMsg().

\code{wrapText()} add next line to strings. This is used with \code{cat()}.
}
\section{Functions}{
\itemize{
\item \code{printText2}: example

\item \code{printLines}: example

\item \code{printMsg}: example

\item \code{getnPrintLabel}: example

\item \code{wrapText}: example
}}

\author{
For any feedback, please contact \code{Myo Minn Oo} via:

Email: \email{dr.myominnoo@gmail.com}

Website: \url{https://myominnoo.github.io/}
}
