% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim.bracket.R
\name{sim.bracket}
\alias{sim.bracket}
\title{Simulate the full bracket starting with an empty bracket}
\usage{
sim.bracket(bracket.empty, prob.matrix = NULL, prob.source = c("pop", "Pom",
  "538"), league = c("men", "women"), year = 2017, num.reps = 1)
}
\arguments{
\item{bracket.empty}{a length-64 character vector giving the field of 64
teams in the tournament, in order of initial overall seeding}

\item{prob.matrix}{a matrix of probabilities, with rows and columns
corresponding to teams, matching the output of bradley.terry().
If NULL, prob.source is used.}

\item{prob.source}{source from which to use round probabilities for
simulation --- "pop": ESPN's population of picks (default),
"Pom": Ken Pomeroy's predictions (kenpom.com), or
"538": predictions form fivethirtyeight.com.
Ignored if prob.matrix is specified.}

\item{league}{which league: "men" (default) or "women", for prob.source.
Ignored if prob.matrix is specified.}

\item{year}{year of tournament, used for prob.source.
Ignored if prob.matrix is specified.}

\item{num.reps}{number of simulations to perform (default is 1)}
}
\value{
a 63-by-num.reps matrix storing the simulation outcome, each
  column encoding the outcome for a single simulation in the following
  order: seeds 1 through 32 after round 1, seeds 1 through 16 after round 2,
  seeds 1 through 8 after round 3, seeds 1 through 4 after round 4,
  seeds 1 and 2 after round 5, and finally seed 1 after round 6 (the
  champion)
}
\description{
Simulate the full bracket starting with an empty bracket
}
\examples{
sim.bracket(bracket.empty = bracket.men.2017, prob.source = "538",
  league = "men", year = 2017)
}
\author{
sspowers
}
