% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/followingNetwork.R
\name{followingNetwork}
\alias{followingNetwork}
\title{followingNetwork function}
\usage{
followingNetwork(TS, timeLagWindow, lagWindow = 0.1, sigma = 0.1)
}
\arguments{
\item{TS}{is a set of time series where \code{TS[i,t,d]} is a numeric value of \code{i}th time series at time \code{t} and dimension \code{d}.}

\item{timeLagWindow}{is a maximum possible time delay in the term of time steps.}

\item{lagWindow}{is a maximum possible time delay in the term of percentage of time length of \code{TS}.}

\item{sigma}{is a threshold of following relation. It is used to discretize an adjacency matrix \code{adjWeightedMat} to be a binary matrix \code{adjBinMat}.}
}
\value{
This function returns adjacency matrices of a following network of \code{TS}.

\item{adjWeightedMat}{ An adjacency matrix of a following network
s.t. if \code{adjWeightedMat[i,j]>0}, then \code{TS[i,,]} follows  \code{TS[j,,]} with a degree \code{adjWeightedMat[i,j]}. }
\item{adjBinMat}{ A binary version of \code{adjWeightedMat} s.t. \code{adjBinMat[i,j] <- (adjWeightedMat[i,j] >=sigma)} for any \code{i,j}.  }
}
\description{
followingNetwork is a support function for calculating a following network of a set of time series
}
\examples{

# Run the function ?

out<-followingNetwork(TS=mFLICA::TS[,60:90,],sigma=0.5)

}
